<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Models\Category;
use App\Models\City;
use App\Models\Car;
use App\Models\CarImage;
use App\Models\CarDocument;
use App\Models\Booking;

class CarController extends Controller
{
    //
    public function getAllCars(Request $request)
    {
        try {
            $cars = Car::orderBy('id', 'desc')->with('gallery');
            if($request->city && $request->city > 0){
                $cars = $cars->where('city_id', $request->city);
            }
            if($request->category && $request->category > 0){
                $cars = $cars->where('category_id', $request->category);
            }
            $cars = $cars->get();
            $response = ['status' => true, 'data' => $cars, 'message' => "Success!"];
            return response($response, 200);
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function getCar(Request $request)
    {
        try {
            if($request->id){
                $car_id = $request->id;
                $car = Car::where('id', $car_id)->with('gallery')->with(['booking' => function ($query){
                    $query->latest();
                }])->first();
                $response = ['status' => true, 'data' => $car, 'message' => "Success!"];
                return response($response, 200);
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Invalid Request"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function getAllCarsByAgency(Request $request)
    {
        try {
            $agency_id = Auth::user()->id;
            $cars = Car::orderBy('id', 'desc')->with('gallery');
            if($request->city && $request->city > 0){
                $cars = $cars->where('city_id', $request->city);
            }
            if($request->category && $request->category > 0){
                $cars = $cars->where('category_id', $request->category);
            }
            if($request->car_status && $request->car_status != ''){
                if($request->car_status == 'rented'){
                    $cars = $cars->where('is_rented', 1);
                }
                if($request->car_status == 'available'){
                    $cars = $cars->where('is_rented', 0);
                }
            }
            $cars = $cars->where('agency_id', $agency_id);
            $cars = $cars->get();
            $response = ['status' => true, 'data' => $cars, 'message' => "Success!"];
            return response($response, 200);
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function addCar(Request $request){
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'name' => 'required',
                    'price_day' => 'required',
                    'price_week' => 'required',
                    'price_month' => 'required',
                    'registration_number' => 'required',
                    'description' => 'required',
                    'category_id' => 'required',
                    'city_id' => 'required',
                    'seats' => 'required',
                    'horse_power' => 'required',
                    'top_speed' => 'required',
                    'transmission' => 'required',
                    'fuel_type' => 'required',
                    'is_rented' => 'required'
                ]
            );
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $agency_id = Auth::user()->id;
            $car = new Car(); 
            $car->agency_id = $agency_id;
            $car->category_id = $request->category_id;
            $car->city_id = $request->city_id;
            $car->name = $request->name;
            $car->registration_number = $request->registration_number;
            $car->description = $request->description;
            $car->expected_availability = $request->expected_availability;
            $car->price_day = $request->price_day;
            $car->price_week = $request->price_week;
            $car->price_month = $request->price_month;
            $car->top_speed = $request->top_speed;
            $car->seats = $request->seats;
            $car->transmission = $request->transmission;
            $car->fuel_type = $request->fuel_type;
            $car->horse_power = $request->horse_power;
            $car->kilometers = $request->kilometers;
            $car->color = $request->color;
            $car->is_rented = $request->is_rented;
            $car->save();
            if($car == true){
                if ($request->hasfile('cover_photo')) {
                    $cover_photo_name = $agency_id . '-' . time() . '-' . rand() . '.' . $request->cover_photo->extension();
                    $car->cover_photo = $cover_photo_name;
                    $request->cover_photo->move(public_path('images/car'), $cover_photo_name);
                }
                if ($request->hasfile('gallery')) {
                    foreach($request->gallery as $gallery){
                        $imageName = $agency_id . '-' . time() . '-' . rand() . '.' . $gallery->extension();
                        //$property->featured_image = $imageName;
                        if($gallery->move(public_path('images/car'), $imageName)){
                            $gallery = new CarImage();
                            $gallery->image = $imageName;
                            $gallery->car_id = $car->id;
                            $gallery->save();
                        }    
                    }
                }
                if ($request->hasfile('document')) {
                    foreach($request->document as $document){
                        $fileName = $agency_id . '-' . time() . '-' . rand() . '.' . $document->extension();
                        //$property->featured_image = $imageName;
                        if($document->move(public_path('documents/car'), $fileName)){
                            $doc = new CarDocument();
                            $doc->file = $fileName;
                            $doc->car_id = $car->id;
                            $doc->save();
                        }    
                    }
                }
                $response = ['status' => true, 'data' => $car, 'message' => "Created successfully."];
                return response($response, 200);
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Something went wrong. Please try again later. Thank you!"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function addBooking(Request $request){
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'car_id' => 'required',
                    'phone' => 'required',
                    'name' => 'required',
                    'from_date' => 'required',
                    'to_date' => 'required'
                ]
            );
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $agency_id = Auth::user()->id;
            $booking = new Booking(); 
            $booking->agency_id = $agency_id;
            $booking->car_id = $request->car_id;
            $booking->phone = $request->phone;
            $booking->name = $request->name;
            $booking->from_date = $request->from_date;
            $booking->to_date = $request->to_date;
            $booking->save();
            if($booking == true){
                $response = ['status' => true, 'data' => $booking, 'message' => "Created successfully."];
                return response($response, 200);
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Something went wrong. Please try again later. Thank you!"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function editBooking(Request $request){
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'booking_id' => 'required',
                    'car_id' => 'required',
                    'phone' => 'required',
                    'name' => 'required',
                    'from_date' => 'required',
                    'to_date' => 'required'
                ]
            );
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $agency_id = Auth::user()->id;
            $booking = Booking::where('id', $request->booking_id)->where('agency_id', $agency_id)->first();
            if($booking){
                $booking->car_id = $request->car_id;
                $booking->phone = $request->phone;
                $booking->name = $request->name;
                $booking->from_date = $request->from_date;
                $booking->to_date = $request->to_date;
                $booking->save();
                if($booking == true){
                    $response = ['status' => true, 'data' => $booking, 'message' => "Success"];
                    return response($response, 200);
                }else{
                    $response = ['status' => false, 'data' => null, 'message' => "Something went wrong. Please try again later. Thank you!"];
                    return response($response, 400);
                }
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Invalid Request"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function carStatus(Request $request){
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'car_id' => 'required',
                    'is_rented' => 'required'
                ]
            );
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $agency_id = Auth::user()->id;
            $car = Car::where('id', $request->car_id)->first();
            if($car){
                $car->is_rented = $request->is_rented == true ? 1 : 0 ;
                $car->expected_availability = $request->expected_availability?$request->expected_availability:$car->expected_availability;
                $car->save();
                if($car == true){
                    $response = ['status' => true, 'data' => $car, 'message' => "Success."];
                    return response($response, 200);
                }else{
                    $response = ['status' => false, 'data' => null, 'message' => "Something went wrong. Please try again later. Thank you!"];
                    return response($response, 400);
                } 
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Invalid Request!"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }
}
