<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Car extends Model
{
    use HasFactory;
    protected $table = 'car';

    public function gallery()
    {
        return $this->hasMany(CarImage::class, 'car_id', 'id');
    }
    public function booking()
    {
        return $this->hasMany(Booking::class, 'car_id', 'id');
    }
    public function category()
    {
        return $this->hasOne(Category::class, 'id', 'category_id');
    }
    public function agency()
    {
        return $this->hasOne(User::class, 'id', 'agency_id');
    }
}
