@extends('layouts.app-admin')
@section('content')
<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Toolbar-->
	<div class="toolbar" id="kt_toolbar">
		<!--begin::Container-->
		<div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
			<!--begin::Page title-->
			<div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
				<!--begin::Title-->
				<h1 class="d-flex text-dark fw-bolder fs-3 align-items-center my-1">Property Details</h1>
				<!--end::Title-->
				<!--begin::Separator-->
				<span class="h-20px border-gray-300 border-start mx-4"></span>
				<!--end::Separator-->
			</div>
			<!--end::Page title-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Toolbar-->
	<!--begin::Post-->
	<div class="post d-flex flex-column-fluid" id="kt_post">
		<!--begin::Container-->
		<div id="kt_content_container" class="container-xxl">
			<!--begin::Order details page-->
			<div class="d-flex flex-column gap-7 gap-lg-10">
				<!--begin::Order summary-->
				<div class="d-flex flex-column flex-xl-row gap-7 gap-lg-10">
					<!--begin::Order details-->
					<div class="card card-flush py-4 flex-row-fluid">
						<!--begin::Card header-->
						<div class="card-header">
							<div class="card-title">
								<h2>Property</h2>
							</div>
						</div>
						<!--end::Card header-->
						<!--begin::Card body-->
						<div class="card-body pt-0">
							<div class="table-responsive">
								<!--begin::Table-->
								<table class="table align-middle table-row-bordered mb-0 fs-6 gy-5 min-w-300px">
									<!--begin::Table body-->
									<tbody class="fw-bold text-gray-600">
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Title</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($property->title);?></td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Status</div>
											</td>
											<td class="fw-bolder text-end">
												<?php echo $property->status == '1' ? '<span class="badge badge-light-success me-auto"> Active </span>' : ( $property->status == '2' ? '<span class="badge badge-light-warning me-auto"> In Review </span>':'<span class="badge badge-light-danger me-auto"> Blocked </span>') ;?>
											</td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Bedroom</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($property->bedroom??'-');?></td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Bathroom</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($property->bathroom??'-');?></td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Floor Level</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($property->floor_level??'-');?></td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Size</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($property->size_sqyd??'-');?></td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Price</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($property->price?'$ '.$property->price:'-');?></td>
										</tr>
									</tbody>
									<!--end::Table body-->
								</table>
								<!--end::Table-->
							</div>
						</div>
						<!--end::Card body-->
					</div>
					<!--end::Order details-->
					<!--begin::Customer details-->
					<div class="card card-flush py-4 flex-row-fluid">
						<!--begin::Card header-->
						<div class="card-header">
							<div class="card-title">
								<h2>User Details</h2>
							</div>
						</div>
						<!--end::Card header-->
						<!--begin::Card body-->
						<div class="card-body pt-0">
							<div class="table-responsive">
								<!--begin::Table-->
								<table class="table align-middle table-row-bordered mb-0 fs-6 gy-5 min-w-300px">
									<!--begin::Table body-->
									<tbody class="fw-bold text-gray-600">
										<!--begin::Customer name-->
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">
												<!--begin::Svg Icon | path: icons/duotune/communication/com006.svg-->
												<span class="svg-icon svg-icon-2 me-2">
													<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
														<path opacity="0.3" d="M22 12C22 17.5 17.5 22 12 22C6.5 22 2 17.5 2 12C2 6.5 6.5 2 12 2C17.5 2 22 6.5 22 12ZM12 7C10.3 7 9 8.3 9 10C9 11.7 10.3 13 12 13C13.7 13 15 11.7 15 10C15 8.3 13.7 7 12 7Z" fill="currentColor" />
														<path d="M12 22C14.6 22 17 21 18.7 19.4C17.9 16.9 15.2 15 12 15C8.8 15 6.09999 16.9 5.29999 19.4C6.99999 21 9.4 22 12 22Z" fill="currentColor" />
													</svg>
												</span>
												<!--end::Svg Icon-->Name</div>
											</td>
											<td class="fw-bolder text-end">
												<div class="d-flex align-items-center justify-content-end">
													<!--begin:: Avatar -->
													<div class="symbol symbol-circle symbol-25px overflow-hidden me-3">
														<a href="#">
															<div class="symbol-label">
																<img src="assets/media/avatars/blank.png" alt="Dan Wilson" class="w-100" />
															</div>
														</a>
													</div>
													<!--end::Avatar-->
													<!--begin::Name-->
													<a href="#" class="text-gray-600 text-hover-primary"><?=ucfirst($property->user->name);?></a>
													<!--end::Name-->
												</div>
											</td>
										</tr>
										<!--end::Customer name-->
										<!--begin::Customer email-->
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">
												<!--begin::Svg Icon | path: icons/duotune/communication/com011.svg-->
												<span class="svg-icon svg-icon-2 me-2">
													<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
														<path opacity="0.3" d="M21 19H3C2.4 19 2 18.6 2 18V6C2 5.4 2.4 5 3 5H21C21.6 5 22 5.4 22 6V18C22 18.6 21.6 19 21 19Z" fill="currentColor" />
														<path d="M21 5H2.99999C2.69999 5 2.49999 5.10005 2.29999 5.30005L11.2 13.3C11.7 13.7 12.4 13.7 12.8 13.3L21.7 5.30005C21.5 5.10005 21.3 5 21 5Z" fill="currentColor" />
													</svg>
												</span>
												<!--end::Svg Icon-->Email</div>
											</td>
											<td class="fw-bolder text-end">
												<a href="#" class="text-gray-600 text-hover-primary"><?=$property->user->email;?></a>
											</td>
										</tr>
										<!--end::Payment method-->
									</tbody>
									<!--end::Table body-->
								</table>
								<!--end::Table-->
							</div>
						</div>
						<!--end::Card body-->
					</div>
					<!--end::Customer details-->
					<!--begin::Documents-->
					<div class="card card-flush py-4 flex-row-fluid">
						<!--begin::Card header-->
						<div class="card-header">
							<div class="card-title">
								<h2>Status</h2>
							</div>
						</div>
						<!--end::Card header-->
						<!--begin::Card body-->
						<div class="card-body pt-0">
							<form action="{{route('admin.propertyEdit')}}" method="post">
								@csrf
								<!--begin::Select2-->
								<input type="hidden" value="<?=$property->id;?>" name="property_id">
								<select class="form-select mb-2" name="status" data-control="select2" data-hide-search="true" data-placeholder="Select an option" id="kt_ecommerce_add_product_status_select">
									<option></option>
									<option value="active" <?=$property->status == 1?'selected="selected"':'';?>>Active</option>
									<option value="in_review" <?=$property->status == 2?'selected="selected"':'';?>>In Review</option>
									<option value="block" <?=$property->status == 0?'selected="selected"':'';?>>Block</option>
								</select>
								<!--end::Select2-->
								<!--begin::Description-->
								<div class="text-muted fs-7">Set the property status.</div>
								<!--end::Description-->
								<br/>
								<input type="submit" class="btn btn-sm btn-primary me-3">
							</form>
						</div>
						<!--end::Card body-->
					</div>
					<!--end::Documents-->
				</div>
				<!--end::Order summary-->
			</div>
			<!--end::Order details page-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Post-->
</div>
<!--end::Content-->
@endsection