<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\CarController;
use App\Http\Controllers\Api\AgencyController;

// Route::get('/user', function (Request $request) {
//     return $request->user();
// })->middleware('auth:sanctum');

Route::prefix('user')->group(function () {
    Route::get('/test', [UserController::class, 'test'])->name('test');
    Route::post('/register', [UserController::class, 'register'])->name('user.register');
    Route::post('/login', [UserController::class, 'login'])->name('user.login');
    Route::post('/update', [UserController::class, 'update'])->name('user.update')->middleware('auth:api');
});

Route::prefix('agency')->group(function () {
    Route::post('/register', [AgencyController::class, 'register'])->name('agency.register');
    Route::post('/login', [AgencyController::class, 'login'])->name('agency.login');
    Route::post('/forgot', [AgencyController::class, 'forgot'])->name('agency.forgot');
    Route::post('/verification', [AgencyController::class, 'verification'])->name('agency.verification');
    Route::post('/reset-password', [AgencyController::class, 'reset_password'])->name('agency.reset');
    Route::post('/cars', [CarController::class, 'getAllCarsByAgency'])->name('cars.all')->middleware('auth:api');
    Route::post('/notifications', [AgencyController::class, 'getAllNotifications'])->name('cars.all')->middleware('auth:api');
    Route::post('/add-car', [CarController::class, 'addCar'])->name('cars.add')->middleware('auth:api');
    Route::post('/add-booking', [CarController::class, 'addBooking'])->name('booking.add')->middleware('auth:api');
    Route::post('/edit-booking', [CarController::class, 'editBooking'])->name('booking.edit')->middleware('auth:api');
    Route::post('/car-status', [CarController::class, 'carStatus'])->name('car.status')->middleware('auth:api');
});

// MISC
Route::get('/categories', [ApiController::class, 'getAllCategories'])->name('categories.all');
Route::get('/countries', [ApiController::class, 'getAllCountries'])->name('countries.all');
Route::get('/cities', [ApiController::class, 'getAllCities'])->name('cities.all');
Route::get('/cars', [CarController::class, 'getAllCars'])->name('cars.all');
Route::get('/car-detail', [CarController::class, 'getCar'])->name('car.detail');
